/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.misc;

import com.google.common.collect.Maps;
import dev.gigaherz.jsonthings.things.events.FlexEventContext;
import dev.gigaherz.jsonthings.things.events.FlexEventHandler;
import dev.gigaherz.jsonthings.things.events.FlexEventResult;
import dev.gigaherz.jsonthings.things.events.IEventRunner;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class FlexEnchantment
extends Enchantment
implements IEventRunner {
    private final Map<String, FlexEventHandler> eventHandlers = Maps.newHashMap();
    private int minLevel;
    private int maxLevel;
    private int baseCost;
    private int perLevelCost;
    private int randomCost;
    private List<Predicate<Enchantment>> blackList = List.of();
    private ItemPredicate itemCompatibility;
    private boolean isTreasure;
    private boolean isCurse;
    private boolean isTradeable = true;
    private boolean isDiscoverable = true;
    private boolean isAllowedOnBooks = true;

    public FlexEnchantment(Enchantment.Rarity rarity, EnchantmentCategory enchantmentCategory, EquipmentSlot[] slots) {
        super(rarity, enchantmentCategory, slots);
    }

    @Override
    public void addEventHandler(String eventName, FlexEventHandler eventHandler) {
        this.eventHandlers.put(eventName, eventHandler);
    }

    @Override
    public FlexEventHandler getEventHandler(String eventName) {
        return this.eventHandlers.get(eventName);
    }

    public void setMinLevel(int minLevel) {
        this.minLevel = minLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public void setBaseCost(int baseCost) {
        this.baseCost = baseCost;
    }

    public void setPerLevelCost(int perLevelCost) {
        this.perLevelCost = perLevelCost;
    }

    public void setRandomCost(int randomCost) {
        this.randomCost = randomCost;
    }

    public void setTreasure(boolean treasure) {
        this.isTreasure = treasure;
    }

    public void setCurse(boolean curse) {
        this.isCurse = curse;
    }

    public void setTradeable(boolean tradeable) {
        this.isTradeable = tradeable;
    }

    public void setDiscoverable(boolean discoverable) {
        this.isDiscoverable = discoverable;
    }

    public void setAllowedOnBooks(boolean allowedOnBooks) {
        this.isAllowedOnBooks = allowedOnBooks;
    }

    public void setBlackList(List<Predicate<Enchantment>> blackList) {
        this.blackList = blackList;
    }

    public void setItemCompatibility(ItemPredicate itemCompatibility) {
        this.itemCompatibility = itemCompatibility;
    }

    public int m_44702_() {
        return this.minLevel;
    }

    public int m_6586_() {
        return this.maxLevel;
    }

    public int m_6183_(int enchantmentLevel) {
        return this.baseCost * enchantmentLevel * this.perLevelCost;
    }

    public int m_6175_(int enchantmentLevel) {
        return this.m_6183_(enchantmentLevel) + this.randomCost;
    }

    protected boolean m_5975_(Enchantment ench) {
        if (this.blackList.stream().anyMatch(pred -> pred.test(ench))) {
            return false;
        }
        return super.m_5975_(ench);
    }

    public boolean m_6591_() {
        return this.isTreasure;
    }

    public boolean m_6589_() {
        return this.isCurse;
    }

    public boolean m_6594_() {
        return this.isTradeable;
    }

    public boolean m_6592_() {
        return this.isDiscoverable;
    }

    public boolean isAllowedOnBooks() {
        return this.isAllowedOnBooks;
    }

    public boolean m_6081_(ItemStack stack) {
        if (this.itemCompatibility != null && !this.itemCompatibility.m_45049_(stack)) {
            return false;
        }
        return super.m_6081_(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return super.canApplyAtEnchantingTable(stack);
    }

    public void m_7677_(LivingEntity user, Entity target, int level) {
        this.runEvent("post_attack", FlexEventContext.of(this, level).with(FlexEventContext.ATTACKER, user).with(FlexEventContext.TARGET, target), () -> {
            super.m_7677_(user, target, level);
            return FlexEventResult.success();
        });
    }

    public void m_7675_(LivingEntity user, Entity attacker, int level) {
        this.runEvent("post_hurt", FlexEventContext.of(this, level).with(FlexEventContext.ATTACKER, attacker).with(FlexEventContext.TARGET, user), () -> {
            super.m_7675_(user, attacker, level);
            return FlexEventResult.success();
        });
    }
}

